/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.builder;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.builder.ControlBuilder;
import de.lessvoid.nifty.builder.EffectBuilder;
import de.lessvoid.nifty.builder.HoverEffectBuilder;
import de.lessvoid.nifty.builder.ImageBuilder;
import de.lessvoid.nifty.builder.PanelBuilder;
import de.lessvoid.nifty.builder.TextBuilder;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectsAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlInteractAttributes;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ElementBuilder {
    private ControlAttributes attributes;
    private ControlInteractAttributes interactAttributes = new ControlInteractAttributes();
    protected List<ElementBuilder> elementBuilders = new ArrayList<ElementBuilder>();
    private List<EffectBuilder> onStartScreen = new ArrayList<EffectBuilder>();
    private List<EffectBuilder> onEndScreen = new ArrayList<EffectBuilder>();
    private List<HoverEffectBuilder> onHover = new ArrayList<HoverEffectBuilder>();
    private List<HoverEffectBuilder> onStartHover = new ArrayList<HoverEffectBuilder>();
    private List<HoverEffectBuilder> onEndHover = new ArrayList<HoverEffectBuilder>();
    private List<EffectBuilder> onClick = new ArrayList<EffectBuilder>();
    private List<EffectBuilder> onFocus = new ArrayList<EffectBuilder>();
    private List<EffectBuilder> onLostFocus = new ArrayList<EffectBuilder>();
    private List<EffectBuilder> onGetFocus = new ArrayList<EffectBuilder>();
    private List<EffectBuilder> onActive = new ArrayList<EffectBuilder>();
    private List<EffectBuilder> onCustom = new ArrayList<EffectBuilder>();
    private List<EffectBuilder> onShow = new ArrayList<EffectBuilder>();
    private List<EffectBuilder> onHide = new ArrayList<EffectBuilder>();

    protected void initialize(ControlAttributes attributes) {
        this.attributes = attributes;
        this.attributes.setInteract(this.interactAttributes);
    }

    public void id(String id) {
        this.attributes.setId(id);
    }

    public void name(String name) {
        this.attributes.setName(name);
    }

    public void backgroundColor(String backgroundColor) {
        this.attributes.setBackgroundColor(backgroundColor);
    }

    public void backgroundColor(Color backgroundColor) {
        this.attributes.setBackgroundColor(backgroundColor.getColorString());
    }

    public void controller(Controller controller) {
        this.attributes.set("controller", controller.getClass().getName());
    }

    public void controller(String controllerClass) {
        this.attributes.set("controller", controllerClass);
    }

    public void color(String color) {
        this.attributes.setColor(color);
    }

    public void color(Color color) {
        this.attributes.setColor(color.getColorString());
    }

    public void selectionColor(String color) {
        this.attributes.setSelectionColor(color);
    }

    public void selectionColor(Color color) {
        this.attributes.setSelectionColor(color.getColorString());
    }

    public void text(String text) {
        this.attributes.setText(text);
    }

    public void backgroundImage(String backgroundImage) {
        this.attributes.setBackgroundImage(backgroundImage);
    }

    public void imageMode(String imageMode) {
        this.attributes.setImageMode(imageMode);
    }

    public void inset(String inset) {
        this.attributes.setInset(inset);
    }

    public void inputMapping(String inputMapping) {
        this.attributes.setInputMapping(inputMapping);
    }

    public void style(String style) {
        this.attributes.setStyle(style);
    }

    public void childLayout(ChildLayoutType childLayout) {
        this.attributes.setChildLayout(childLayout.getLayout());
    }

    public void childLayoutVertical() {
        this.childLayout(ChildLayoutType.Vertical);
    }

    public void childLayoutHorizontal() {
        this.childLayout(ChildLayoutType.Horizontal);
    }

    public void childLayoutCenter() {
        this.childLayout(ChildLayoutType.Center);
    }

    public void childLayoutAbsolute() {
        this.childLayout(ChildLayoutType.Absolute);
    }

    public void childLayoutAbsoluteInside() {
        this.childLayout(ChildLayoutType.AbsoluteInside);
    }

    public void childLayoutOverlay() {
        this.childLayout(ChildLayoutType.Overlay);
    }

    public void height(String height) {
        this.attributes.setHeight(height);
    }

    public void width(String width) {
        this.attributes.setWidth(width);
    }

    public void x(String x) {
        this.attributes.setX(x);
    }

    public void y(String y) {
        this.attributes.setY(y);
    }

    public void childClip(boolean childClip) {
        this.attributes.setChildClip(String.valueOf(childClip));
    }

    public void visible(boolean visible) {
        this.attributes.setVisible(String.valueOf(visible));
    }

    public void focusable(boolean focusable) {
        this.attributes.setFocusable(String.valueOf(focusable));
    }

    public void focusableInsertBeforeElementId(String focusableInsertBeforeElementId) {
        this.attributes.setFocusableInsertBeforeElementId(focusableInsertBeforeElementId);
    }

    public void textHAlign(Align align) {
        this.attributes.set("textHAlign", align.getLayout());
    }

    public void textHAlignLeft() {
        this.textHAlign(Align.Left);
    }

    public void textHAlignRight() {
        this.textHAlign(Align.Right);
    }

    public void textHAlignCenter() {
        this.textHAlign(Align.Center);
    }

    public void textVAlign(VAlign valign) {
        this.attributes.set("textVAlign", valign.getLayout());
    }

    public void textVAlignTop() {
        this.textVAlign(VAlign.Top);
    }

    public void textVAlignBottom() {
        this.textVAlign(VAlign.Bottom);
    }

    public void textVAlignCenter() {
        this.textVAlign(VAlign.Center);
    }

    public void align(Align align) {
        this.attributes.setAlign(align.getLayout());
    }

    public void alignLeft() {
        this.align(Align.Left);
    }

    public void alignRight() {
        this.align(Align.Right);
    }

    public void alignCenter() {
        this.align(Align.Center);
    }

    public void valign(VAlign valign) {
        this.attributes.setVAlign(valign.getLayout());
    }

    public void valignTop() {
        this.valign(VAlign.Top);
    }

    public void valignBottom() {
        this.valign(VAlign.Bottom);
    }

    public void valignCenter() {
        this.valign(VAlign.Center);
    }

    public void visibleToMouse(boolean visibleToMouse) {
        this.attributes.setVisibleToMouse(String.valueOf(visibleToMouse));
    }

    public void visibleToMouse() {
        this.visibleToMouse(true);
    }

    public void invisibleToMouse() {
        this.visibleToMouse(false);
    }

    public void font(String font) {
        this.attributes.setFont(font);
    }

    public void filename(String filename) {
        this.attributes.setFilename(filename);
    }

    public void padding(String padding) {
        this.attributes.setPadding(padding);
    }

    public void paddingLeft(String padding) {
        this.attributes.setPaddingLeft(padding);
    }

    public void paddingRight(String padding) {
        this.attributes.setPaddingRight(padding);
    }

    public void paddingTop(String padding) {
        this.attributes.setPaddingTop(padding);
    }

    public void paddingBottom(String padding) {
        this.attributes.setPaddingBottom(padding);
    }

    public void set(String key, String value) {
        this.attributes.set(key, value);
    }

    public String get(String key) {
        return this.attributes.get(key);
    }

    public void panel(PanelBuilder panelBuilder) {
        this.elementBuilders.add(panelBuilder);
    }

    public void text(TextBuilder textBuilder) {
        this.elementBuilders.add(textBuilder);
    }

    public void image(ImageBuilder imageBuilder) {
        this.elementBuilders.add(imageBuilder);
    }

    public void control(ControlBuilder controlBuilder) {
        this.elementBuilders.add(controlBuilder);
    }

    public void onStartScreenEffect(EffectBuilder onStartScreenEffect) {
        this.onStartScreen.add(onStartScreenEffect);
    }

    public void onEndScreenEffect(EffectBuilder onEndScreenEffect) {
        this.onEndScreen.add(onEndScreenEffect);
    }

    public void onHoverEffect(HoverEffectBuilder onHoverEffect) {
        this.onHover.add(onHoverEffect);
    }

    public void onStartHoverEffect(HoverEffectBuilder onStartHoverEffect) {
        this.onStartHover.add(onStartHoverEffect);
    }

    public void onEndHoverEffect(HoverEffectBuilder onEndHoverEffect) {
        this.onEndHover.add(onEndHoverEffect);
    }

    public void onClickEffect(EffectBuilder onClickEffect) {
        this.onClick.add(onClickEffect);
    }

    public void onFocusEffect(EffectBuilder onFocusEffect) {
        this.onFocus.add(onFocusEffect);
    }

    public void onLostFocusEffect(EffectBuilder onLostFocusEffect) {
        this.onLostFocus.add(onLostFocusEffect);
    }

    public void onGetFocusEffect(EffectBuilder onGetFocusEffect) {
        this.onGetFocus.add(onGetFocusEffect);
    }

    public void onActiveEffect(EffectBuilder onActiveEffect) {
        this.onActive.add(onActiveEffect);
    }

    public void onShowEffect(EffectBuilder onShowEffect) {
        this.onShow.add(onShowEffect);
    }

    public void onHideEffect(EffectBuilder onHideEffect) {
        this.onHide.add(onHideEffect);
    }

    public void onCustomEffect(EffectBuilder onCustomEffect) {
        this.onCustom.add(onCustomEffect);
    }

    public void interactOnClick(String method) {
        this.interactAttributes.setOnClick(method);
    }

    public void interactOnRelease(String onRelease) {
        this.interactAttributes.setOnRelease(onRelease);
    }

    public void interactOnMouseOver(String onMouseOver) {
        this.interactAttributes.setOnMouseOver(onMouseOver);
    }

    public void interactOnClickRepeat(String onClickRepeat) {
        this.interactAttributes.setOnClickRepeat(onClickRepeat);
    }

    public void interactOnClickMouseMove(String onClickMouseMove) {
        this.interactAttributes.setOnClickMouseMove(onClickMouseMove);
    }

    public void interactOnClickAlternateKey(String onClickAlternateKey) {
        this.interactAttributes.setOnClickAlternateKey(onClickAlternateKey);
    }

    public String percentage(int percentage) {
        return Integer.toString(percentage) + "%";
    }

    public String pixels(int px) {
        return Integer.toString(px) + "px";
    }

    public List<ElementBuilder> getElementBuilders() {
        return Collections.unmodifiableList(this.elementBuilders);
    }

    public Element build(Nifty nifty, Screen screen, Element parent) {
        ElementType type = this.buildElementType();
        Element result = nifty.createElementFromType(screen, parent, type);
        screen.layoutLayers();
        return result;
    }

    public ElementType buildElementType() {
        this.connectAttributes();
        ElementType thisType = this.attributes.createType();
        if (this.attributes.isAutoId()) {
            thisType.getAttributes().remove("id");
        }
        this.attributes.connect(thisType);
        for (int i = 0; i < this.elementBuilders.size(); ++i) {
            thisType.addElementType(this.elementBuilders.get(i).buildElementType());
        }
        return thisType;
    }

    private void connectAttributes() {
        int i;
        this.attributes.setEffects(this.createEffects());
        for (i = 0; i < this.onStartScreen.size(); ++i) {
            this.attributes.addEffectsOnStartScreen(this.onStartScreen.get(i).getAttributes());
        }
        for (i = 0; i < this.onEndScreen.size(); ++i) {
            this.attributes.addEffectsOnEndScreen(this.onEndScreen.get(i).getAttributes());
        }
        for (i = 0; i < this.onHover.size(); ++i) {
            this.attributes.addEffectsOnHover(this.onHover.get(i).getAttributes());
        }
        for (i = 0; i < this.onStartHover.size(); ++i) {
            this.attributes.addEffectsOnStartHover(this.onStartHover.get(i).getAttributes());
        }
        for (i = 0; i < this.onEndHover.size(); ++i) {
            this.attributes.addEffectsOnEndHover(this.onEndHover.get(i).getAttributes());
        }
        for (i = 0; i < this.onClick.size(); ++i) {
            this.attributes.addEffectsOnClick(this.onClick.get(i).getAttributes());
        }
        for (i = 0; i < this.onFocus.size(); ++i) {
            this.attributes.addEffectsOnFocus(this.onFocus.get(i).getAttributes());
        }
        for (i = 0; i < this.onLostFocus.size(); ++i) {
            this.attributes.addEffectsOnLostFocus(this.onLostFocus.get(i).getAttributes());
        }
        for (i = 0; i < this.onGetFocus.size(); ++i) {
            this.attributes.addEffectsOnGetFocus(this.onGetFocus.get(i).getAttributes());
        }
        for (i = 0; i < this.onActive.size(); ++i) {
            this.attributes.addEffectsOnActive(this.onActive.get(i).getAttributes());
        }
        for (i = 0; i < this.onCustom.size(); ++i) {
            this.attributes.addEffectsOnCustom(this.onCustom.get(i).getAttributes());
        }
        for (i = 0; i < this.onShow.size(); ++i) {
            this.attributes.addEffectsOnShow(this.onShow.get(i).getAttributes());
        }
        for (i = 0; i < this.onHide.size(); ++i) {
            this.attributes.addEffectsOnHide(this.onHide.get(i).getAttributes());
        }
    }

    private ControlEffectsAttributes createEffects() {
        return new ControlEffectsAttributes();
    }

    public static enum VAlign {
        Top("top"),
        Bottom("bottom"),
        Center("center");

        private String valign;

        private VAlign(String valign) {
            this.valign = valign;
        }

        public String getLayout() {
            return this.valign;
        }
    }

    public static enum Align {
        Left("left"),
        Right("right"),
        Center("center");

        private String align;

        private Align(String align) {
            this.align = align;
        }

        public String getLayout() {
            return this.align;
        }
    }

    public static enum ChildLayoutType {
        Vertical("vertical"),
        Horizontal("horizontal"),
        Center("center"),
        Absolute("absolute"),
        AbsoluteInside("absolute-inside"),
        Overlay("overlay");

        private String layout;

        private ChildLayoutType(String layout) {
            this.layout = layout;
        }

        public String getLayout() {
            return this.layout;
        }
    }
}

